% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cronologia.R
\name{create_tml}
\alias{create_tml}
\title{Create a Vertical HTML Timeline from a Data Frame}
\usage{
create_tml(
  df,
  smr,
  dsc,
  smr_col = "white",
  smr_bgcol = "#002240",
  dsc_col = "#1D1D1D",
  dsc_bgcol = "#FFFFFF",
  dsc_size = "14px",
  open = FALSE
)
}
\arguments{
\item{df}{a data frame containing the necessary information.}

\item{smr}{the column name that will be used as the summary component.}

\item{dsc}{the column name that will be used as the description component.}

\item{smr_col}{text color for the summary component. Defaults to 'white'.}

\item{smr_bgcol}{background-color for the summary component. Defaults to "#002240".}

\item{dsc_col}{text color for the description component. Defaults to "#1D1D1D".}

\item{dsc_bgcol}{background-color for the description component. Defaults to "#FFFFFF".}

\item{dsc_size}{font size of the description component. Defaults to "14px".}

\item{open}{logical, whether to open by default the summary components. Default to FALSE}
}
\value{
A Vertical HTML Time Line Widget
}
\description{
Create a Vertical HTML Timeline from a Data Frame
}
\examples{

if(interactive()) {

df <- data.frame(


 date_release = c("May 31, 2005",
                  "July 14, 2008",
                  "July 16, 2012 "),

 description = c("Batman Begins",
                 "The Dark Knight",
                 "The Dark Knight Rises")
)

ui <- fluidPage(

 br(),

 h1("Batman Trigoly Timeline", style = "text-align:center"),

 br(),


 create_tml(df,
           "date_release",
           "description"),



)

server <- function(input, output) {}

shinyApp(ui = ui, server = server)

}
}
