#' Trace plot of MCMC output
#'
#' @description
#' Produces a separate plot for each parameter in the JAGS model. Each
#' plot shows iterations vs sampled values.
#'
#' @param x An object generated by \code{\link{crossnma}}.
#' @param \dots Additional arguments (passed on to
#'   \code{\link[coda]{traceplot}})
#'
#' @return
#' No return value (plot function).
#'
#' @author Tasnim Hamza \email{tasnim.hamza@@ispm.unibe.ch}
#'
#' @seealso \code{\link{crossnma}}, \code{\link[coda]{traceplot}}
#'
#' @keywords hplot
#'
#' @examples
#' \dontrun{
#' # We conduct a network meta-analysis assuming a random-effects
#' # model.
#' # The data comes from randomized-controlled trials and
#' # non-randomized studies (combined naively)
#' head(ipddata) # participant-level data
#' stddata # study-level data
#'
#' # Create a JAGS model
#' mod <- crossnma.model(treat, id, relapse, n, design,
#'   prt.data = ipddata, std.data = stddata,
#'   reference = "A", trt.effect = "random", method.bias = "naive")
#'
#' # Fit JAGS model
#' set.seed(1909)
#' fit <- crossnma(mod)
#'
#' # Trace plot of model parameters
#' plot(fit)
#' }
#'
#' @method plot crossnma
#' @export


plot.crossnma <- function(x, ...)
  traceplot(x$samples, ...)
