% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\docType{data}
\name{mtcars2}
\alias{mtcars2}
\title{Modified \code{mtcars} dataset}
\format{
A data frame with 32 observations on 11 variables with labels.
}
\source{
\preformatted{
library(dplyr)
mtcars2 = mtcars \%>\% 
    mutate(vs=ifelse(vs==0, "vshaped", "straight"),
       am=ifelse(am==0, "auto", "manual")) \%>\% 
    mutate_at(c("cyl", "gear"), factor) \%>\% 
    expss::apply_labels( #I also could have used [import_labels] or even `Hmisc::label`
        mpg="Miles/(US) gallon",
        cyl="Number of cylinders",
        disp="Displacement (cu.in.)",
        hp="Gross horsepower",
        drat="Rear axle ratio",
        wt="Weight (1000 lbs)",
        qsec="1/4 mile time",
        vs="Engine",
        am="Transmission",
        gear="Number of forward gears",
       carb="Number of carburetors"
    )
}
}
\usage{
mtcars2
}
\description{
Modified \code{mtcars} dataset so:
\itemize{
\item every column is labelled (using \code{label} attribute from \code{expss} package, compatible with \code{Hmisc} package)
\item \code{gear} and \code{cyl} columns are considered as numerical factors
\item \code{vs} and \code{am} columns are considered as character vector
}

See \code{\link{mtcars}} for more informations on the original "Motor Trend Car Road Tests" dataset.
}
\examples{
library(crosstable)
ct=crosstable(mtcars2, by=vs)
ct
as_flextable(ct)
}
\keyword{datasets}
