% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compact.R
\name{ct_compact}
\alias{ct_compact}
\alias{ct_compact.data.frame}
\alias{ct_compact.crosstable}
\alias{ct_compact.default}
\alias{compact}
\alias{compact.data.frame}
\alias{compact.crosstable}
\alias{compact.default}
\title{Generic function to compact a table (publication formatting)}
\usage{
\method{ct_compact}{data.frame}(
  data,
  name_from,
  name_to = "variable",
  wrap_cols = NULL,
  rtn_flextable = FALSE,
  ...
)

\method{ct_compact}{crosstable}(
  data,
  name_from = c("label", ".id"),
  name_to = "variable",
  keep_id = FALSE,
  ...
)
}
\arguments{
\item{data}{the object to compact}

\item{...}{additional arguments (not used)}

\item{name_from}{name of the column to be collapsed when compacting}

\item{name_to}{name of the column that will receive the collapsed column. Will be created if it doesn't exist.}

\item{wrap_cols}{name of the columns to wrap}

\item{rtn_flextable}{whether to return a formatted \code{\link[flextable:flextable]{flextable::flextable()}} object or a simple \code{data.frame}}

\item{keep_id}{\code{glue} pattern to keep the column name along with the label. If \code{TRUE}, default to \code{"{label} ({.id})"}.}
}
\value{
a compacted data.frame
}
\description{
Generic function to compact a table (publication formatting)
}
\examples{
#dataframes
x=iris[c(1:5,51:55,101:105),]
ct_compact(x, name_from="Species")
ct_compact(x, name_from="Species", name_to="Petal.Length")
x$Species2 = substr(x$Species, 1, 1)
ct_compact(x, name_from="Species", wrap_cols="Species2")

#crosstables
x=crosstable(mtcars2, c(disp,hp,am), by=vs, test=TRUE, effect=TRUE)
ct_compact(x)
ct_compact(x, name_from=".id")
}
\author{
Dan Chaltiel
}
