% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosstalk.R
\docType{class}
\name{ClientValue}
\alias{ClientValue}
\title{ClientValue object}
\format{An \code{\link{R6Class}} generator object}
\usage{
ClientValue
}
\description{
An object that can be used in a \href{http://shiny.rstudio.com}{Shiny} server
function to get or set a crosstalk variable that exists on the client. The
client copy of the variable is the canonical copy, so there is no direct
"set" method that immediately changes the value; instead, there is a
\code{sendUpdate} method that sends a request to the browser to change the
value, which will then cause the new value to be relayed back to the server.
}
\section{Methods}{

\describe{
  \item{\code{initialize(name, group = "default", session = shiny::getDefaultReactiveDomain())}}{
    Create a new ClientValue object to reflect the crosstalk variable
    specified by \code{group} and \code{name}. The \code{session} indicates
    which Shiny session to connect to, and defaults to the current session.
  }
  \item{\code{get()}}{
Read the value. This is a reactive operation akin to reading a reactive
value, and so can only be done in a reactive context (e.g. in a
\code{\link[shiny]{reactive}}, \code{\link[shiny]{observe}}, or
\code{\link[shiny]{isolate}} block).
  }
  \item{\code{sendUpdate(value)}}{
    Send a message to the browser asking it to update the crosstalk var to
    the given value. This update does not happen synchronously, that is, a
    call to \code{get()} immediately following \code{sendUpdate(value)} will
    not reflect the new value. The value must be serializable as JSON using
    jsonlite.
  }
}
}

\examples{
library(shiny)

server <- function(input, output, session) {
  cv <- ClientValue$new("var1", "group1")

  r <- reactive({
    # Don't proceed unless cv$get() is a non-NULL value
    validate(need(cv$get(), message = FALSE))

    runif(cv$get())
  })

  observeEvent(input$click, {
    cv$sendUpdate(NULL)
  })
}

}
\keyword{datasets}
