% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select}
\alias{select}
\alias{select.CrunchDataset}
\title{Select columns from a Crunch dataset}
\usage{
\method{select}{CrunchDataset}(.data, ...)
}
\arguments{
\item{.data}{A \code{CrunchDataset}}

\item{...}{names of variables in \code{.data} or other valid selection functions,
passed to \code{tidyselect::vars_select()}}
}
\value{
\code{.data} with only the selected variables.
}
\description{
This function uses "tidy select" methods of subsetting the columns of a
dataset. It's another way of doing \code{ds[,vars]}.
}
\examples{
\dontrun{
ds \%>\%
   select(contains("ear")) \%>\%
   filter(gear > 4) \%>\%
   collect()
}
}
