% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_helpers.R
\name{print.evaluation}
\alias{print.evaluation}
\title{Print an 'evaluation' object}
\usage{
\method{print}{evaluation}(x, digits = max(3, getOption("digits") - 4), ...)
}
\arguments{
\item{x}{Object to print}

\item{digits}{Numeric. Number of digits to print. Defaults to \code{max(3, getOption("digits")-4)}}

\item{...}{Further arguments to print.evaluation}
}
\description{
Pretty prints an object of class 'evaluation'
}
\details{
Prints the object to look like a table
}
\examples{
data(iris)
# A classification test
test <- createtest(data = iris, 
                  dependent = "Species",
                  problem = "classification",
                  method = "randomForest",
                  name = "An example classification test",
                  train_index = sample(150, 100)
)
\dontrun{
# Run the test. The result is an object of class "evaluation"
evaluation <- runtest(test) 
print(evaluation)
}
}

