% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categories.R
\name{changeCategoryID}
\alias{changeCategoryID}
\title{Change the id of a category for a categorical variable}
\usage{
changeCategoryID(variable, from, to)
}
\arguments{
\item{variable}{the variable in a crunch dataset that will be changed (note: the variable must be categorical, categorical array, or multiple response)}

\item{from}{the (old) id identifying the category you want to change}

\item{to}{the (new) id for the category}
}
\value{
\code{variable} with category \code{from} and all associated data values mapped to id \code{to}
}
\description{
Changes the id of a category from an existing value to a new one.
The variable can be a categorical, categorical array, or multiple response
variable. The category changed will have the same numeric value and missing
status as before. The one exception to this is if the numeric value is the
same as the id, then the new numeric value will be the same as the new id.
}
\examples{
\dontrun{
ds$country <- changeCategoryID(ds$country, 2, 6)
}
}
