% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/folders.R
\name{mv}
\alias{mv}
\alias{mkdir}
\title{Functions to manipulate variables' folder structure}
\usage{
mv(dataset, variables, path)

mkdir(dataset, path, variables = NULL)
}
\arguments{
\item{dataset}{A Crunch dataset}

\item{variables}{A Variable, selection of variables from \code{dataset}, or any
other object that can be moved to a folder. For \code{mkdir}, \code{variables} is
optional.}

\item{path}{A character "path" to the folder: either a
vector of nested folder names or a single string with nested folders
separated by a delimiter ("/" default, configurable via
\code{options(crunch.delimiter)})}
}
\value{
\code{dataset}, with the folder at \code{path} guaranteed to be created and
\code{variables}, if specified, moved into it.
}
\description{
Variables in Crunch datasets are organized into folders, like in a file
system. These functions allow you to create new folders and move objects into
folders. Their names, \code{mv} and \code{mkdir}, suggest their Unix file utility
inspiration.
}
\details{
The functions have some differences from the strict behavior of their Unix
ancestors. For one, they work recursively, without additional arguments:
\code{mkdir} will make every directory necessary to construct the requested path,
even if all parent directories didn't already exist; and \code{mv} doesn't
require that the directory to move to already exist. \code{mkdir} also takes an
optional \code{variables} argument, which allows you to say "make this directory
\strong{and} put these variables in it" in one command. As a result of these
behaviors, \code{mv} and \code{mkdir} here are essentially the same, just with
arguments in reverse order: \code{mv} is move "variables" to "path", while \code{mkdir}
is create "path" and put "variables" in it.

Both functions take "dataset" as the first argument, so they naturally
support pipelining (as with the \code{\%>\%} operator).
}
\examples{
\dontrun{
ds <- loadDataset("Example survey")
ds <- mv(ds, c("gender", "age", "educ"), "Demographics")
ds <- mkdir(ds, "Key Performance Indicators/Brand X")
# These can also be chained together
require(magrittr)
ds <- ds \%>\%
    mv(c("aware_x", "nps_x"), "Key Performance Indicators/Brand X") \%>\%
    mv(c("aware_y", "nps_y"), "Key Performance Indicators/Brand Y")
}
}
\seealso{
\code{\link[=folder]{folder()}}
}
