% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube-transforms.R
\docType{methods}
\name{subtotalArray,CrunchCube-method}
\alias{subtotalArray,CrunchCube-method}
\alias{applyTransforms}
\alias{subtotalArray}
\title{Calculate the transforms from a CrunchCube}
\usage{
\S4method{subtotalArray}{CrunchCube}(x, headings = FALSE)

applyTransforms(x, array = cubeToArray(x), ...)
}
\arguments{
\item{x}{a CrunchCube}

\item{headings}{for \code{subtotalArray}: a logical indicating if the headings
should be included with the subtotals (default: \code{FALSE})}

\item{array}{an array to use, if not using the default array from the cube
itself. (Default: not used, pulls an array from the cube directly)}

\item{...}{arguments to pass to \code{calcTransforms}, for example \code{include}}
}
\value{
an array with any transformations applied
}
\description{
\code{applyTransforms} calculates transforms (e.g. \link[=SubtotalsHeadings]{Subtotals}) on a CrunchCube.
Currently only the row transforms are supported. This is useful if you want
to use the values from the subtotals of the CrunchCube in an analysis.
}
\details{
Including the \code{include} argument allows you to specify which parts of the
CrunchCube to return. The options can be any of the following: "cube_cells"
for the untransformed values from the cube itself, "subtotals" for the
subtotal insertions, and "headings" for any additional headings. Any
combination of these can be given, by default all will be given.

\code{subtotalArray(cube)} is a convenience function that is equivalent to
\code{applyTransforms(cube, include = c("subtotals"))}
}
\examples{
\dontrun{
# to get an array of just the subtotals
subtotalArray(crtabs(~opinion, ds))
#    Agree Disagree
#       47       35

# to get the full array with the subtotals but not headings
applyTransforms(crtabs(~opinion, ds), include = c("cube_cells", "subtotals"))
#             Strongly Agree             Somewhat Agree                      Agree
#                         23                         24                         47
# Neither Agree nor Disagree          Strongly Disagree                   Disagree
#                         18                         19                         35
#          Somewhat Disagree
#                         16
# to get the full array with the headings but not subtotals
applyTransforms(crtabs(~opinion, ds), include = c("cube_cells", "headings"))
#               All opinions             Strongly Agree             Somewhat Agree
#                         NA                         23                         24
# Neither Agree nor Disagree          Strongly Disagree          Somewhat Disagree
#                         18                         19                         16
}

}
