% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archive-and-publish.R
\docType{methods}
\name{archive-and-publish}
\alias{archive-and-publish}
\alias{archive}
\alias{is.archived}
\alias{is.draft}
\alias{is.published}
\alias{is.archived<-}
\alias{is.draft<-}
\alias{is.published<-}
\alias{publish}
\alias{is.archived,CrunchDataset-method}
\alias{is.draft,CrunchDataset-method}
\alias{is.published,CrunchDataset-method}
\alias{is.archived<-,CrunchDataset,logical-method}
\alias{is.draft<-,CrunchDataset,logical-method}
\alias{is.published<-,CrunchDataset,logical-method}
\alias{is.archived,DatasetCatalog-method}
\alias{is.draft,DatasetCatalog-method}
\alias{is.published,DatasetCatalog-method}
\alias{is.archived<-,DatasetCatalog,logical-method}
\alias{is.draft<-,DatasetCatalog,logical-method}
\alias{is.published<-,DatasetCatalog,logical-method}
\title{Get and set "archived" and "published" status of a dataset}
\usage{
is.archived(x)

is.archived(x) <- value

is.draft(x)

is.draft(x) <- value

is.published(x)

is.published(x) <- value

\S4method{is.archived}{CrunchDataset}(x)

\S4method{is.draft}{CrunchDataset}(x)

\S4method{is.published}{CrunchDataset}(x)

\S4method{is.archived}{CrunchDataset,logical}(x) <- value

archive(x)

\S4method{is.draft}{CrunchDataset,logical}(x) <- value

\S4method{is.published}{CrunchDataset,logical}(x) <- value

publish(x)

\S4method{is.archived}{DatasetCatalog}(x)

\S4method{is.draft}{DatasetCatalog}(x)

\S4method{is.published}{DatasetCatalog}(x)

\S4method{is.archived}{DatasetCatalog,logical}(x) <- value

\S4method{is.draft}{DatasetCatalog,logical}(x) <- value

\S4method{is.published}{DatasetCatalog,logical}(x) <- value
}
\arguments{
\item{x}{CrunchDataset}

\item{value}{logical}
}
\value{
For the getters, the logical value of whether the dataset is
archived, in draft mode, or published, where draft and published are
inverses. The setters return the dataset.
}
\description{
"Archived" datasets are excluded from some views. "Draft" datasets are
visible only to editors, while published datasets are available to all viewers.
A dataset can either be published or in draft, but not both.
These properties are accessed and set with the "is" methods. You can also
set the properties by assigning into the function. The verb functions
\code{archive} and \code{publish} are alternate versions of the setters.
}
\examples{
\dontrun{
ds <- loadDataset("mtcars")
is.draft(ds)     # FALSE
is.published(ds) # TRUE
identical(is.draft(ds), !is.published(ds))
# Can make a dataset a "draft" by:
is.draft(ds) <- TRUE
is.published(ds) # FALSE
# Could also have set is.published(ds) <- FALSE
# Now, can go the other way by setting is.draft, is.published, or:
ds <- publish(ds)
is.published(ds) # TRUE

is.archived(ds)  # FALSE
is.archived(ds) <- TRUE
is.archived(ds)  # TRUE
# Could have achieved the same effect by:
ds <- archive(ds)
}
}
