% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sliding-categories.R
\name{slideCategories}
\alias{slideCategories}
\title{Create sliding subvariable definitions}
\usage{
slideCategories(variable, step, width, ..., complete = TRUE, useNA = FALSE)
}
\arguments{
\item{variable}{A categorical crunch variable}

\item{step}{number of categories between starting points of groups}

\item{width}{number of categories wide the grouping should be}

\item{...}{additional attributes to be included in the \code{VariableDefinition},
can be either functions that take the category names to be included in the
sliding group and returns a single string, or a character vector the same length
as the number of subvariables that will be created.}

\item{complete}{whether to only include category groupings that are as wide as width
(defaults to \code{TRUE})}

\item{useNA}{whether to use missing categories from the original variable (defaults
to \code{FALSE})}
}
\value{
A list of \code{VariableDefinition}s appropriate for use in \code{deriveArray()}
}
\description{
Create a multiple response array variable by sliding through category levels
and selecting potentially overlapping sets of categories.
}
\examples{
\dontrun{
data <- data.frame(
    wave = factor(c("a", "b", "c", "d", "e"))
)

ds <- newDataset(data, "Sliding Categories", project = "p1")

# Make an MR variable where subvariable is 1 step apart, and with 3 categories wide
# and name subvariables with vector
ds$wave_step1_wide3 <- deriveArray(
   slideCategories(ds$wave, step = 1, width = 3, name = c("a - c", "b - d", "c - e")),
   "Sliding example 1"
)

# You can also make names (and other subvariable metadata like alias or description)
# with a function:
ds$wave_step2_wide2 <- deriveArray(
   slideCategories(
     ds$wave,
     step = 2,
     width = 2,
     name = function(x) paste(x[1], "-", x[length(x)])
   ),
   "Sliding example 2"
)
}
}
