% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validations.R
\name{check_cryst_symm_validity}
\alias{check_cryst_symm_validity}
\title{Validity and compatibility of a cry object of class 'cryst_symm'}
\usage{
check_cryst_symm_validity(x, message = FALSE)
}
\arguments{
\item{x}{Object of class 'cryst_symm'.}

\item{message}{A logical variable. If TRUE, the function
prints a message on the errors, if any
(default is FALSE, i.e. no message printed).}
}
\value{
ans A logical value. TRUE means that the input is a valid object of class'cryst_symm'.
}
\description{
An object of class 'cryst_symm' is a named list of length 4. The first field is a
character string, the second field is a \eqn{3\times 3} array and the third and fourth
field are \eqn{3 \times 1} arrays.
}
\examples{
# Create an object of class 'cryst_symm'
x <- cryst_symm(15)

# Check its validity
check_cryst_symm_validity(x)

# Now change a field
x$PG[[1]] <- matrix(rep(0,times=9),ncol=3)

# Check validity again
check_cryst_symm_validity(x,TRUE)

}
