% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_S3.R
\name{create_unit_cell.bravais}
\alias{create_unit_cell.bravais}
\title{Unit cell starting from a Bravais symbol}
\usage{
\method{create_unit_cell}{bravais}(a, ...)
}
\arguments{
\item{a}{An object of class "bravais".}

\item{...}{Additional arguments passed to the create_unit_cell methods}
}
\value{
An object of class "unit_cell". It is a named list of length 6 whose
        last three slots are of "angle" class.
}
\description{
Method to create a "unit_cell" object starting from a "bravais" object.
The Bravais symbols indicate the 14 possible Bravais lattices. A few
examples are "aP", "oF", etc. The cell parameters assigned are assigned
randomly, but are compatible with the Bravais lattice.
}
\examples{
# Create a "unit_cell" object from a monoclinic primitive Bravais lattice
# Cell parameters generated automatically.
bt <- bravais("mP")
uc <- create_unit_cell(bt)
print(uc)

}
