% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry.R
\name{translate_SG}
\alias{translate_SG}
\title{Translation of space group symbols, numbers, etc.}
\usage{
translate_SG(value, SG_in = "number", SG_out = "xHM", set = 1)
}
\arguments{
\item{value}{A string or an integer number corresponding to the space group being
investigated.}

\item{SG_in}{A string representing the space group format for the input. Possible values are:
\itemize{
  \item{1) "number"}
  \item{2) "ccp4"}
  \item{3) "Hall"}
  \item{4) "xHM"}
  \item{5) "old"}
}}

\item{SG_out}{A string representing the space group format for the output. Possible values are:
\itemize{
  \item{1) "number"}
  \item{2) "ccp4"}
  \item{3) "Hall"}
  \item{4) "xHM"}
  \item{5) "old"}
}}

\item{set}{Specific setting for the given space group. A number like 1,2,...
It is used if for a same symbol there are more than one choice.}
}
\value{
list_SG A named list with two fields. The first field, "msg", is a character string
  representing the space group format needed as output. Possible values are the same as
  those for SG_in. The second field, "ans", is TRUE only if a valid symbol for "msg" is
  found.
}
\description{
Function to find out space group symbol given number and vice-versa.
}
\details{
This function returns either a number of a specific symbol corresponding to a
crystallographic space group. The input is an integer number or a character symbol
identifying a specific space group. The output is, similarly, the corresponding
character symbol or number, according to what is specified in the input.
Possible formats are:
\itemize{
  \item{1) Space group number}
  \item{2) Hall symbol (e.g. ' P 2yb (z,x,y)')}
  \item{3) Extended Hermann-Mauguin symbol (e.g. 'P 1 1 21')}
}
If more than one setting is implied in an ambiguous way in the input value,
then the first setting will be selected by default for the output value, unless
argument "set" is set to another value.
}
\examples{
# Space Group P1 corresponds to number 1
translate_SG(value=1,SG_in="number",SG_out="xHM")

}
