% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_event.R
\name{add_event}
\alias{add_event}
\title{add eventlines to
the chart}
\usage{
add_event(event_data, ...)
}
\arguments{
\item{event_data}{a \link{data.frame} with index, event and colors.}

\item{...}{arguments pass interally by \link{chart}, ignore.}
}
\value{
Invisbly returns a plotly object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Common types of event indicators include earnings release dates, dividend payouts, central bank interest rate decisions, chart pattern breakouts, and geopolitical events like elections or geopolitical tensions.
The choice of event indicators depends on the trader's or analyst's specific objectives and the factors they believe are most relevant to the asset's price movements.
}
\details{
TBA
}
\section{Note}{
The eventlines are drawn using \code{\link[plotly:layout]{plotly::layout()}}, so all existing
eventlines will be replaced each time you call \code{\link[=add_event]{add_event()}}.
}

\examples{
# script: scr_addEvents
# date: 2023-12-07
# author: Serkan Korkmaz, serkor1@duck.com
# objective: Describe the usage
# of addEvents
# script start;

# laod library
library(cryptoQuotes)

# 1) Generate random events
# of buys and sells and convert
# to data.frame
#
# Note: tibbles, data.tables are also supported
# but only base R is shown here to avoid
# too many dependencies
set.seed(1903)
event_data <- ATOM[
  sample(1:nrow(ATOM), size = 2)
]

# 1.1) Extract the index
# from the event data
index <- zoo::index(
  event_data
)

# 1.2) Convert the coredata
# into a data.frame
event_data <- as.data.frame(
  zoo::coredata(event_data)
)

# 1.3) Add the index into the data.frame
# case insensitive
event_data$index <- index

# 1.4) add events to the data.
# here we use Buys and Sells.
event_data$event <- rep(
  x = c('Buy', 'Sell'),
  lenght.out = nrow(event_data)
)

# 1.5) add colors based
# on the event; here buy is colored
# darkgrey, and if the position is closed
# with profit the color is green
event_data$color <- ifelse(
  event_data$event == 'Buy',
  yes = 'darkgrey',
  no  = ifelse(
    subset(event_data, event == 'Buy')$Close < subset(event_data, event == 'Sell')$Close,
    yes = 'green',
    no  = 'red'
  )
)

# 1.6) modify the event to add
# closing price at each event
event_data$event <- paste0(
  event_data$event, ' @', event_data$Close
)

# 2) Chart the the klines
# and add the buy and sell events
chart(
  ticker     = ATOM,
  main       = kline(),
  sub        = list(
    volume()
  ),
  indicator = list(
    bollinger_bands()
  ),
  event_data = event_data,
  options = list(
    dark = TRUE,
    deficiency = FALSE
  )
)

# script end;
}
\seealso{
Other chart indicators: 
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{chart}()},
\code{\link{dema}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other subcharts: 
\code{\link{fgi}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{volume}()}
}
\concept{chart indicators}
\concept{subcharts}
