% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FUN.R
\name{remove_bound}
\alias{remove_bound}
\title{remove upper and lower bounds
from an XTS object}
\usage{
remove_bound(xts, bounds = c("upper"))
}
\arguments{
\item{xts}{A xts-object that needs its bounds modified.}

\item{bounds}{A character vector of length 1.
Has to be one of \code{c('upper','lower','both')}. Defaults to Upper.}
}
\value{
Returns an xts-class object with its bounds removed.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{\link[stats:window]{stats::window()}}-function has inclusive upper and lower bounds,
which in some cases is an undesirable feature. This high level function
removes the bounds if desired
}
\examples{
# script start;

# 1) check index of BTCUSDT and
# the Fear and Greed Index
setequal(
  zoo::index(BTC),
  zoo::index(FGIndex)
)

# 2) to align the indices,
# we use the convincience functions
# by splitting the FGI by the BTC index.
FGIndex <- cryptoQuotes::split_window(
  xts = cryptoQuotes::FGIndex,
  by  = zoo::index(BTC),

  # Remove upper bounds of the
  # index to avoid overlap between
  # the dates.
  #
  # This ensures that the FGI is split
  # according to start of each weekly
  # BTC candle
  bounds = 'upper'
)

# 3) as splitWindow returns a list
# it needs to passed into calibrateWindow
# to ensure comparability
FGIndex <- cryptoQuotes::calibrate_window(
  list = FGIndex,

  # As each element in the list can include
  # more than one row, each element needs to be aggregated
  # or summarised.
  #
  # using xts::first gives the first element
  # of each list, along with its values
  FUN  = xts::first
)


# 3) check if candles aligns
# accordingly
stopifnot(
  setequal(
    zoo::index(BTC),
    zoo::index(FGIndex)
  )
)


# script end;
}
\seealso{
Other utility: 
\code{\link{calibrate_window}()},
\code{\link{split_window}()},
\code{\link{write_xts}()}
}
\concept{utility}
