% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_ACB.R
\name{format_ACB}
\alias{format_ACB}
\title{Formats transactions with ACB}
\usage{
format_ACB(
  data,
  as.revenue = c("staking", "interests", "mining"),
  sup.loss = TRUE,
  cl = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{The dataframe}

\item{as.revenue}{Which should be treated as revenue, in list of
\code{c("staking", "interests", "mining")}.}

\item{sup.loss}{Logical, whether to take superficial losses into account.}

\item{cl}{Number of cores to use for parallel processing.}

\item{verbose}{Logical: if \code{FALSE}, does not print progress bar or warnings
to console.}
}
\value{
A data frame, formatted for the Adjusted Cost Base (ACB).
}
\description{
Formats transaction data with Adjusted Cost Base (ACB),
along with ACB per share and realized capital gains or losses.
}
\examples{
all.data <- format_shakepay(data_shakepay)
format_ACB(all.data, verbose = FALSE)
}
