% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_prices.R
\name{match_prices}
\alias{match_prices}
\title{Get Fair Market Value (FMV) of transactions}
\usage{
match_prices(
  data,
  my.coins = NULL,
  start.date = "2021-01-01",
  list.prices = NULL,
  force = FALSE
)
}
\arguments{
\item{data}{The dataframe}

\item{my.coins}{Your coins to match}

\item{start.date}{What date to start reporting prices for.}

\item{list.prices}{A \code{list.prices} object from which to fetch coin prices.}

\item{force}{Whether to force recreating \code{list.prices} even though
it already exists (e.g., if you added new coins or new dates).}
}
\value{
A data frame, with the following added columns: spot.rate.
}
\description{
Matches prices obtained through the \code{prepare_list_prices()}
function with the transaction data frame.
}
\examples{
data <- format_shakepay(data_shakepay)[c(1:2)]
match_prices(data)
}
