% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_list_prices.R
\name{prepare_list_prices}
\alias{prepare_list_prices}
\title{Prepare the list of coins for prices}
\usage{
prepare_list_prices(
  coins,
  start.date,
  end.date = lubridate::now("UTC"),
  force = FALSE
)
}
\arguments{
\item{coins}{Which coins to include in the list.}

\item{start.date}{What date to start reporting prices for.}

\item{end.date}{What date to end reporting prices for.}

\item{force}{Whether to force recreating \code{list.prices} even though
it already exists (e.g., if you added new coins or new dates).}
}
\value{
A data frame, with the following columns: timestamp, id, slug,
name, symbol, ref_cur, open, high, low, close, volume, market_cap,
time_open, time_close, time_high, time_low, spot.rate2, currency, date2.
}
\description{
Prepare the list of coins for prices.
}
\details{
The \link[crypto2:crypto_history]{crypto2::crypto_history} API is at times a bit capricious. You might
need to try a few times before it process correctly and without
errors.
}
\examples{
my.coins <- c("BTC", "ETH")
my.list.prices <- prepare_list_prices(coins = my.coins, start.date = "2023-01-01")
head(my.list.prices)
}
