/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.qa.diff.UnmatchedEdgeExtracter;
import com.vividsolutions.jump.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;

public class DiffSegments {
    private FeatureCollection[] fc = new FeatureCollection[2];
    private UnmatchedEdgeExtracter[] uee = new UnmatchedEdgeExtracter[2];
    private TaskMonitor monitor;

    public DiffSegments(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    public void setSegments(int index, FeatureCollection fc) {
        this.fc[index] = fc;
        this.uee[index] = new UnmatchedEdgeExtracter();
        Iterator it = fc.getFeatures().iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            this.uee[index].add(f.getGeometry());
        }
    }

    public FeatureCollection computeDiffEdges(int index) {
        ArrayList diffEdges = new ArrayList();
        UnmatchedEdgeExtracter otherUee = this.uee[1 - index];
        Iterator i = this.fc[index].getFeatures().iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            otherUee.getDiffEdges(f.getGeometry(), diffEdges);
        }
        return FeatureDatasetFactory.createFromGeometry(diffEdges);
    }
}

