/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import java.util.Arrays;

public class MapImageFormatChooser {
    private boolean transparencyRequired = false;
    private boolean useLossy = false;

    public static boolean isKnownFormat(String format) {
        return format.equals("GIF") || format.equals("PNG") || format.equals("JPEG");
    }

    public void setTransparencyRequired(boolean transparencyRequired) {
        this.transparencyRequired = transparencyRequired;
    }

    public void setPreferLossyCompression(boolean useLossy) {
        this.useLossy = useLossy;
    }

    public String chooseFormat(String[] formats) {
        if (formats.length == 0) {
            throw new IllegalArgumentException();
        }
        String[] order = new String[3];
        if (this.transparencyRequired) {
            order[0] = "PNG";
            order[1] = "GIF";
            order[2] = "JPEG";
        } else if (this.useLossy) {
            order[0] = "JPEG";
            order[1] = "PNG";
            order[2] = "GIF";
        } else {
            order[0] = "PNG";
            order[1] = "JPEG";
            order[2] = "GIF";
        }
        Arrays.sort(formats);
        for (int i = 0; i < order.length; ++i) {
            if (Arrays.binarySearch(formats, order[i]) < 0) continue;
            return order[i];
        }
        return null;
    }
}

