/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.polygonize;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.polygonize.EdgeRing;
import com.vividsolutions.jts.operation.polygonize.PolygonizeGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Polygonizer {
    private LineStringAdder lineStringAdder = new LineStringAdder();
    protected PolygonizeGraph graph;
    protected Collection dangles = new ArrayList();
    protected List cutEdges = new ArrayList();
    protected List invalidRingLines = new ArrayList();
    protected List holeList = null;
    protected List shellList = null;
    protected List polyList = null;

    public void add(Collection geomList) {
        Iterator i = geomList.iterator();
        while (i.hasNext()) {
            Geometry geometry = (Geometry)i.next();
            this.add(geometry);
        }
    }

    public void add(Geometry g) {
        g.apply(this.lineStringAdder);
    }

    private void add(LineString line) {
        if (this.graph == null) {
            this.graph = new PolygonizeGraph(line.getFactory());
        }
        this.graph.addEdge(line);
    }

    public Collection getPolygons() {
        this.polygonize();
        return this.polyList;
    }

    public Collection getDangles() {
        this.polygonize();
        return this.dangles;
    }

    public Collection getCutEdges() {
        this.polygonize();
        return this.cutEdges;
    }

    public Collection getInvalidRingLines() {
        this.polygonize();
        return this.invalidRingLines;
    }

    private void polygonize() {
        if (this.polyList != null) {
            return;
        }
        this.polyList = new ArrayList();
        if (this.graph == null) {
            return;
        }
        this.dangles = this.graph.deleteDangles();
        this.cutEdges = this.graph.deleteCutEdges();
        List edgeRingList = this.graph.getEdgeRings();
        ArrayList validEdgeRingList = new ArrayList();
        this.invalidRingLines = new ArrayList();
        this.findValidRings(edgeRingList, validEdgeRingList, this.invalidRingLines);
        this.findShellsAndHoles(validEdgeRingList);
        Polygonizer.assignHolesToShells(this.holeList, this.shellList);
        this.polyList = new ArrayList();
        Iterator i = this.shellList.iterator();
        while (i.hasNext()) {
            EdgeRing er = (EdgeRing)i.next();
            this.polyList.add(er.getPolygon());
        }
    }

    private void findValidRings(List edgeRingList, List validEdgeRingList, List invalidRingList) {
        Iterator i = edgeRingList.iterator();
        while (i.hasNext()) {
            EdgeRing er = (EdgeRing)i.next();
            if (er.isValid()) {
                validEdgeRingList.add(er);
                continue;
            }
            invalidRingList.add(er.getLineString());
        }
    }

    private void findShellsAndHoles(List edgeRingList) {
        this.holeList = new ArrayList();
        this.shellList = new ArrayList();
        Iterator i = edgeRingList.iterator();
        while (i.hasNext()) {
            EdgeRing er = (EdgeRing)i.next();
            if (er.isHole()) {
                this.holeList.add(er);
                continue;
            }
            this.shellList.add(er);
        }
    }

    private static void assignHolesToShells(List holeList, List shellList) {
        Iterator i = holeList.iterator();
        while (i.hasNext()) {
            EdgeRing holeER = (EdgeRing)i.next();
            Polygonizer.assignHoleToShell(holeER, shellList);
        }
    }

    private static void assignHoleToShell(EdgeRing holeER, List shellList) {
        EdgeRing shell = EdgeRing.findEdgeRingContaining(holeER, shellList);
        if (shell != null) {
            shell.addHole(holeER.getRing());
        }
    }

    private class LineStringAdder
    implements GeometryComponentFilter {
        private LineStringAdder() {
        }

        public void filter(Geometry g) {
            if (g instanceof LineString) {
                Polygonizer.this.add((LineString)g);
            }
        }
    }
}

