% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrFindActiveSubstanceSynonyms.R
\name{ctrFindActiveSubstanceSynonyms}
\alias{ctrFindActiveSubstanceSynonyms}
\title{Find synonyms of an active substance}
\usage{
ctrFindActiveSubstanceSynonyms(activesubstance = "")
}
\arguments{
\item{activesubstance}{An active substance, in an atomic character vector}
}
\value{
A character vector of the active substance (input parameter) and
 synonyms, or NULL if active substance was not found and may be invalid
}
\description{
An active substance can be identified by a recommended international
nonproprietary name (INN), a trade or product name, or a company code(s).
Retrieves the names of substance which are searched for by "CTGOV"
when querying for a given active substance.
}
\examples{
\dontrun{

ctrFindActiveSubstanceSynonyms(activesubstance = "imatinib")
# [1] "imatinib" "gleevec" "sti 571" "glivec" "CGP 57148" "st1571"
}
}
