% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrGetQueryUrl.R
\name{ctrGetQueryUrl}
\alias{ctrGetQueryUrl}
\title{Get query details}
\usage{
ctrGetQueryUrl(url = "", register = "")
}
\arguments{
\item{url}{URL such as from the browser address bar.
If not specified, clipboard contents will be checked for
a suitable URL.
For automatically copying the user's query of a register
in a web browser to the clipboard, see
\ifelse{latex}{\out{\href{https://rfhb.github.io/ctrdata/#id_2-script-to-automatically-copy-users-query-from-web-browser}{here}}}{\href{https://rfhb.github.io/ctrdata/#id_2-script-to-automatically-copy-users-query-from-web-browser}{here}}.
Can also contain a query term such as from
\link{dbQueryHistory}()["query-term"].}

\item{register}{Optional name of register (one of "EUCTR", "CTGOV",
"ISRCTN" or "CTIS") in case `url` is a query term}
}
\value{
A data frame (or tibble, if \code{tibble} is loaded)
with column names `query-term` and `query-register`.
The data frame (or tibble) can be passed as such as parameter
`query-term` to \link{ctrLoadQueryIntoDb} and as parameter
`url` to \link{ctrOpenSearchPagesInBrowser}.
}
\description{
Extracts query parameters and register name from parameter `url` or
from the clipboard, into which the URL of a register search was copied.
}
\examples{

# user copied into the clipboard the URL from
# the address bar of the browser that shows results
# from a query in one of the trial registers
try(ctrGetQueryUrl(), silent = TRUE)

# extract query parameters from search result URL
# (URL was cut for the purpose of formatting only)
ctrGetQueryUrl(
    url = paste0(
        "https://classic.clinicaltrials.gov/ct2/results?",
        "cond=&term=AREA\%5BMaximumAge\%5D+RANGE\%5B0+days\%2C+28+days\%5D",
        "&type=Intr&rslt=&age_v=&gndr=&intr=Drugs\%2C+Investigational",
        "&titles=&outc=&spons=&lead=&id=&cntry=&state=&city=&dist=",
        "&locn=&phase=2&rsub=&strd_s=01\%2F01\%2F2015&strd_e=01\%2F01\%2F2016",
        "&prcd_s=&prcd_e=&sfpd_s=&sfpd_e=&rfpd_s=&rfpd_e=&lupd_s=&lupd_e=&sort="
    )
)

ctrGetQueryUrl("https://www.clinicaltrialsregister.eu/ctr-search/trial/2007-000371-42/results")
ctrGetQueryUrl("https://euclinicaltrials.eu/app/#/view/2022-500041-24-00")
ctrGetQueryUrl("https://euclinicaltrials.eu/app/#/search?sponsorTypeCode=1")
ctrGetQueryUrl("https://classic.clinicaltrials.gov/ct2/show/NCT01492673?cond=neuroblastoma")
ctrGetQueryUrl("https://clinicaltrials.gov/ct2/show/NCT01492673?cond=neuroblastoma")
ctrGetQueryUrl("https://www.clinicaltrials.gov/study/NCT01467986?aggFilters=ages:child")
ctrGetQueryUrl("https://www.isrctn.com/ISRCTN70039829")

}
