% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctDataHelp.R
\name{longexample}
\alias{longexample}
\title{longexample}
\format{7 by 8 matrix containing ctsem long format data, for two subjects, 
with three manifest variables Y1, Y2, Y3, 
one time dependent predictor TD1, two time independent predictors TI1 and TI2, 
and absolute timing information Time.}
\description{
Simulated example dataset for the ctsem package
}
\examples{
\dontrun{
#long example (using datastructure base)
Tpoints=30
testm<-ctModel(Tpoints=Tpoints,n.latent=1,n.TDpred=1,n.TIpred=2,n.manifest=3,    
  LAMBDA=matrix(1,ncol=1,nrow=3),
  DRIFT=diag(-.3,1),
  DIFFUSION=diag(.1,1),
  CINT=diag(2,1),
  MANIFESTVAR=diag(1,3),
  TDPREDEFFECT=diag(.2,1),
  TIPREDEFFECT=matrix(.8,nrow=1,ncol=2),
  TDPREDVAR=diag(1,1*(Tpoints)),
  TIPREDVAR=diag(1,2)
)
longexample<-round(ctGenerate(testm,n.subjects=2,logdtsd = 1,burnin=3,wide=FALSE)[c(1:3,32:35),],2)
longexample[2,c(2,7)]<-NA
longexample[4,c(3)]<-NA
longexample
save(longexample,file='.\\\\data\\\\longexample.rda')
}
}
