% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_confidenceRegion.R
\name{stan_confidenceRegion}
\alias{stan_confidenceRegion}
\title{Extract functions of multiple variables from a stanfit object}
\usage{
stan_confidenceRegion(
  stanfit,
  parstrings,
  prefuncstring = "(",
  joinfuncstring = " + ",
  postfuncstring = ")"
)
}
\arguments{
\item{stanfit}{object of class stanfit.}

\item{parstrings}{vector of strings containing partial (or full) matches of parameter names.
When more than one string is passed, functions are computed based on the combination of the first match for
each string, then the second match for each string, etc. The first match of the first string is only ever combined
with the first match of the second, similarly for the 2nd match, etc.}

\item{prefuncstring}{string containing front element of function. E.g., 'exp(' for an exponential region.}

\item{joinfuncstring}{string used to join the (possibly) multiple parameters involved.}

\item{postfuncstring}{string containing end element of function. E.g., ') *2' to multiply the result by 2.}
}
\value{
matrix of values of the specified interactions at each iteration.
}
\description{
Can be useful for determining quantiles or plotting multidimensional regions -- 
for instance in case of colinearity of predictors.
}
\examples{
temp<-stan_confidenceRegion(stanfit=ctstantestfit$stanfit, 
  parstrings=c('pop_DRIFT[1,2]','pop_DRIFT[2,1]'))
t(apply(temp,2,quantile))
}
