% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_checkdivergences.R
\name{stan_checkdivergences}
\alias{stan_checkdivergences}
\title{Analyse divergences in a stanfit object}
\usage{
stan_checkdivergences(sf, nupars = "all")
}
\arguments{
\item{sf}{stanfit object.}

\item{nupars}{either the string 'all', or an integer reflecting how many pars 
(from first to nupars) to use.}
}
\value{
A list of four matrices. $locationsort and $sdsort contian the bivariate interactions of 
unconstrained parameters, sorted by either the relative location of any divergences, or the relative standard deviation.
$locationmeans and $sdmeans collapse across the bivariate interactions to return the means for each parameter.
}
\description{
Analyse divergences in a stanfit object
}
\examples{
\donttest{
sunspots<-sunspot.year
sunspots<-sunspots[50: (length(sunspots) - (1988-1924))]
id <- 1
time <- 1749:1924
datalong <- cbind(id, time, sunspots)

#setup model
ssmodel <- ctModel(type='stanct', n.latent=2, n.manifest=1, 
 manifestNames='sunspots', 
 latentNames=c('ss_level', 'ss_velocity'),
 LAMBDA=matrix(c( 1, 'ma1| log(1+(exp(param)))' ), nrow=1, ncol=2),
 DRIFT=matrix(c(0, 'a21 | -log(1+exp(param))', 1, 'a22'), nrow=2, ncol=2),
 MANIFESTMEANS=matrix(c('m1|param * 10 + 44'), nrow=1, ncol=1),
 MANIFESTVAR=diag(0,1), #As per original spec
 CINT=matrix(c(0, 0), nrow=2, ncol=1),
 DIFFUSION=matrix(c(0, 0, 0, "diffusion"), ncol=2, nrow=2))

#fit
ssfit <- ctStanFit(datalong, ssmodel, iter=2, 
  optimize=FALSE, chains=1)
  
stan_checkdivergences(ssfit$stanfit$stanfit) #stan object
}
}
