% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{adaptive_burnin_filter}
\alias{adaptive_burnin_filter}
\title{Calculate adaptive burn-in retain/discard list}
\usage{
adaptive_burnin_filter(curves, percent_threshold)
}
\arguments{
\item{curves}{A cuperdec curve table calculated with
\code{\link{calculate_curve}}.}

\item{percent_threshold}{A percentage of the target-source in a sample above
which a sample is considered 'retained'.}
}
\value{
A tibble with each row showing each sample and whether it
  passed the specified filter.
}
\description{
Automates a selection of a per-sample 'burn in' based on the
nature of the sample's curve itself (rather than supplying a hard value) by
finding the point from which the 'fluctuation' of the curve doesn't exceed
the mean +- SD of the total curve.
}
\examples{
data(cuperdec_taxatable_ex)
data(cuperdec_database_ex)

taxa_table <- load_taxa_table(cuperdec_taxatable_ex)
iso_database <- load_database(cuperdec_database_ex, target = "oral")

curve_results <- calculate_curve(taxa_table, iso_database)
adaptive_burnin_filter(curve_results, percent_threshold = 0.1)
}
