% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singlearm_functions.R
\name{singlearmDesign}
\alias{singlearmDesign}
\title{Find single-arm trials using stochastic curtailment}
\usage{
singlearmDesign(
  nmin,
  nmax,
  C = NA,
  stages = NA,
  p0,
  p1,
  alpha,
  power,
  maxthetaF = p1,
  minthetaE = p1,
  bounds = "wald",
  return.only.admissible = TRUE,
  max.combns = 1e+06,
  maxthetas = NA,
  fixed.r = NA,
  exact.thetaF = NA,
  exact.thetaE = NA,
  progressBar = FALSE
)
}
\arguments{
\item{nmin}{Minimum permitted sample size. Should be a multiple of block size or number of stages.}

\item{nmax}{Maximum permitted sample size. Should be a multiple of block size or number of stages.}

\item{C}{Block size. Vectors, i.e., multiple values, are permitted.}

\item{stages}{Number of interim analyses or "stages". Only required if not setting block size C. Vectors, i.e., multiple values, are permitted.}

\item{p0}{Probability for which to control the type-I error-rate}

\item{p1}{Probability for which to control the power}

\item{alpha}{Significance level}

\item{power}{Required power (1-beta).}

\item{maxthetaF}{Maximum value of lower CP threshold theta_F_max. Defaults to p1.}

\item{minthetaE}{Minimum value of upper threshold theta_E_min. Defaults to p1.}

\item{bounds}{choose what final rejection boundaries should be searched over: Those of A'Hern ("ahern"), Wald ("wald") or no constraints (NA). Defaults to "wald".}

\item{return.only.admissible}{Logical. Returns only admissible design realisations if TRUE, otherwise returns all feasible designs. Defaults to TRUE.}

\item{max.combns}{Provide a maximum number of ordered pairs (theta_F, theta_E). Defaults to 1e6.}

\item{maxthetas}{Provide a maximum number of CP values used to create ordered pairs (theta_F, theta_E). Can be used instead of max.combns. Defaults to NA.}

\item{fixed.r}{Choose what final rejection boundaries should be searched over. Useful for reproducing a particular design realisation. Defaults to NA.}

\item{exact.thetaF}{Provide an exact value for lower threshold theta_F. Useful for reproducing a particular design realisation. Defaults to NA.}

\item{exact.thetaE}{Provide an exact value for upper threshold theta_E. Useful for reproducing a particular design realisation. Defaults to NA.}

\item{progressBar}{Logical. If TRUE, shows progress bar. Defaults to FALSE.}
}
\value{
Output is a list of two dataframes. The first, $input, is a one-row data frame that contains all the arguments used in the call. The second, $all.des, contains the operating characteristics of all admissible designs found.
}
\description{
This function finds admissible design realisations for single-arm binary outcome trials, using stochastic curtailment.
The output can be used as the sole argument in the function 'drawDiagram', which will return the stopping boundaries for the
admissible design of your choice. Monitoring frequency can set in terms of block(/cohort) size ("C") or number of stages ("stages").
}
\examples{
output <- singlearmDesign(nmin = 30,
 nmax = 30,
 C = 5,
 p0 = 0.1,
 p1 = 0.4,
 power = 0.8,
 alpha = 0.05)
}
\author{
Martin Law, \email{martin.law@mrc-bsu.cam.ac.uk}
}
