% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layout.R
\docType{methods}
\name{layColBind}
\alias{layColBind}
\alias{layColBind,Layout,Layout-method}
\title{Take two Layout objects and combine by rows.}
\usage{
layColBind(x, y, widths = c(1, 1), addmax = TRUE)

\S4method{layColBind}{Layout,Layout}(x, y, widths = c(1, 1),
  addmax = TRUE)
}
\arguments{
\item{x}{object of class Layout}

\item{y}{object of class Layout}

\item{widths}{a vector with relative widths used in combining 
the x and y layouts.}

\item{addmax}{if true (default) the ids of the plots in the second 
layout will be shifted by the number of plots in 
the first layout.}
}
\description{
Take two Layout objects and combine by rows.
}
\examples{
l1 = layCreate(matrix(c(1:2),ncol = 2),widths=c(4,1))
l2 = layCreate(matrix(c(1:4),ncol = 2),widths=c(1,1))
lb = layColBind(l1,l2)
layShow(lb)

}
