% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum.R
\name{racusum}
\alias{racusum}
\title{Risk-adjusted CUSUM Charts}
\usage{
racusum(patient_risks, patient_outcomes, limit, weights = NA,
  odds_multiplier = 2, reset = TRUE, limit_method = c("constant",
  "dynamic"))
}
\arguments{
\item{patient_risks}{Double. Vector of patient risk scores (individual risk of adverse event)}

\item{patient_outcomes}{Integer. Vector of binary patient outcomes (0,1)}

\item{limit}{Double. Control limit for signalling performance change}

\item{weights}{Double. Optional vector of weights, if empty, standard CUSUM weights are calculated with weights_t}

\item{odds_multiplier}{Double. Odds multiplier of adverse event under the alternative hypothesis (<1 looks for decreases)}

\item{reset}{Logical. Reset the CUSUM after a signal to 0; defaults to TRUE}

\item{limit_method}{"constant" or "dynamic"}
}
\description{
Calculate risk-adjusted CUSUM charts for performance data
}
\examples{
# Patients risks are usually known from Phase I.
# If not, these risk scores can be simulated.

# define possible patient risk scores
risks <- c(0.001, 0.01, 0.1, 0.002, 0.02, 0.2)

# sample risk population of size n = 100
set.seed(2046)
patient_risks <- sample(x = risks, size = 100, replace = TRUE)

# control limit can be obtained with racusum_limit_sim(),
# here it is set to an arbitrary value (2.96),
# or dynamic control limits with racusum_limit_dpcl()

##### RA-CUSUM of in-control process
# simulate patient outcome for performace as expected
set.seed(2046)
patient_outcomes <- as.logical(rbinom(
  n = 100,
  size = 1,
  prob = patient_risks
))

racusum(patient_risks,
  patient_outcomes,
  limit = 2.96
)

#### RA-CUSUM of out-of-control process
# simulate patient outcome for deviating performance

set.seed(2046)
patient_outcomes <- as.logical(rbinom(n = 100, size = 1, prob = patient_risks * 2))
#'
racusum(patient_risks,
  patient_outcomes,
  limit = 2.96
)
}
