# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name gscusum
#' @title Group-sequential CUSUM chart
#' @description Calculate GSCUSUM chart for non-risk-adjusted processes.
#' 
#' @param input_outcomes Matrix. First column are binary patient outcomes (0,1). Second column are continuous sequence of block identifier.
#' @param failure_probability Double. Baseline failure probability
#' @param odds_multiplier Double. Odds multiplier of adverse event under the alternative hypothesis (<1 looks for decreases)
#' @param limit Double. Control limit for signalling performance change
#' @param max_num_shuffles Integer. Number of shuffles (i.e. different sequences of observations)
#' @param seed Integer. Seed for RNG (if = 0 random seed is set (default))
#' @param quantiles Double. Vector of requested quantiles of GSCUSUM distribution
#' @return gscusum matrix, signal probability, average CUSUM value and specified quantiles for every observation.
#' @example 
#' input_outcomes <- matrix(c(gscusum_example_data$y, gscusum_example_data$block_identifier), ncol = 2)
#' gs <- gscusum(input_outcomes = input_outcomes, failure_probability = 0.2, odds_multiplier = 2, limit = 2, max_num_shuffles = 1000,  seed = 2098,  quantiles = c(0,0.25,0.5,0.75,1))
#' 
#' @export
gscusum <- function(input_outcomes, failure_probability, odds_multiplier, limit, quantiles, max_num_shuffles = 10000L, seed = 0L) {
    .Call(`_cusum_gscusum`, input_outcomes, failure_probability, odds_multiplier, limit, quantiles, max_num_shuffles, seed)
}

#' @name ragscusum
#' @title RA-Grouped-CUSUM chart
#' 
#' @description Calculate GSCUSUM chart for risk-adjusted processes.
#' 
#' @param input_ra_outcomes Matrix. First column are binary patient outcomes (0,1). Second column are patient individual weight for adverse event (failure) and third column patient individual weight for no adverse event (success). Fourth column are continuous sequence of block identifier.
#' @param limit Double. Control limit for signalling performance change
#' @param max_num_shuffles Integer. Number of shuffles (i.e. different sequences of observations)
#' @param seed Integer. Seed for RNG (if = 0 random seed is set (default))
#' @param quantiles Double. Vector of requested quantiles of RA-GSCUSUM distribution
#' @return ragscusum NumericMatix, signal probability, average CUSUM value and specified quantiles for every observation.
#' @example
#' weight_s <- log((1) / (1 + ragscusum_example_data$score))
#' weight_f <- log((2) / (1 + ragscusum_example_data$score))
#' y <- ragscusum_example_data$y
#' block_identifier <- ragscusum_example_data$block_identifier
#' ra_outcomes <- matrix(c(y, weight_f, weight_s, block_identifier), ncol = 4)
#' gs <- ragscusum(ra_outcomes,limit = 2,max_num_shuffles = 1000,seed = 1008,quantiles = c(0,0.5,1))
#' 
#' @export
ragscusum <- function(input_ra_outcomes, limit, quantiles, max_num_shuffles = 10000L, seed = 0L) {
    .Call(`_cusum_ragscusum`, input_ra_outcomes, limit, quantiles, max_num_shuffles, seed)
}

