% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvSelect.R
\name{cvSelect}
\alias{cvSelect}
\alias{selectStepAIC}
\alias{selectTrans}
\alias{compareFolds}
\title{Cross-Validate a Model-Selection Procedure}
\usage{
cvSelect(
  procedure,
  data,
  k = 10,
  reps = 1,
  save.coef = k <= 10,
  seed,
  ncores = 1,
  ...
)

selectStepAIC(
  data,
  indices,
  model,
  criterion = mse,
  AIC = TRUE,
  save.coef = TRUE,
  ...
)

selectTrans(
  data,
  indices,
  save.coef = TRUE,
  model,
  criterion = mse,
  predictors,
  response,
  family = c("bcPower", "bcnPower", "yjPower", "basicPower"),
  family.y = c("bcPower", "bcnPower", "yjPower", "basicPower"),
  rounded = TRUE,
  ...
)

compareFolds(object, digits = 3, ...)
}
\arguments{
\item{procedure}{a model-selection procedure function (see Details).}

\item{data}{full data frame for model selection.}

\item{k}{perform k-fold cross-validation (default is 10); \code{k}
may be a number or \code{"loo"} or \code{"n"} for n-fold (leave-one-out)
cross-validation.}

\item{reps}{number of times to replicate k-fold CV (default is \code{1})}

\item{save.coef}{save the coefficients from the selected models? (default is \code{TRUE} if
\code{k} is 10 or smaller, \code{FALSE} otherwise)}

\item{seed}{for R's random number generator; not used for n-fold cross-validation.}

\item{ncores}{number of cores to use for parallel computations
(default is \code{1}, i.e., computations aren't done in parallel)}

\item{...}{arguments to be passed to \code{procedure()}.}

\item{indices}{indices of cases in data defining the current fold.}

\item{model}{a regression model object fit to data.}

\item{criterion}{a CV criterion function.}

\item{AIC}{if \code{TRUE} (the default) use the AIC as the
model-selection criterion; if \code{FALSE}, use the BIC.
The \code{k} argument to \code{\link[MASS]{stepAIC}()}
is set accordingly (note that this is distinct from the number of
folds \code{k}).}

\item{predictors}{character vector of names of the predictors in the model
to transform; if missing, no predictors will be transformed.}

\item{response}{name of the response variable; if missing, the response
won't be transformed.}

\item{family}{transformation family for the predictors, one of
\code{"bcPower", "bcnPower", "yjPower", "basicPower"},
with \code{"bcPower"} as the default. These are the names of transformation
functions in the \pkg{car} package; see \code{\link[car]{bcPower}}}

\item{family.y}{transformation family for the response,
with \code{"bcPower"} as the default.}

\item{rounded}{if \code{TRUE} (the default) use nicely rounded versions
of the estimated transformation parameters (see \code{\link[car]{bcPower}}).}

\item{object}{an object of class \code{"cvSelect"}.}

\item{digits}{significant digits for printing coefficients,
(default \code{3}).}
}
\value{
An object of class \code{"cvSelect"}, inheriting from class \code{"cv"}, with the averaged CV criterion
(\code{"CV crit"}), the adjusted average CV criterion (\code{"adj CV crit"}),
the criterion for the model applied to the full data (\code{"full crit"}),
the number of folds (\code{"k"}), the seed for R's random-number
generator (\code{"seed"}), and (optionally) a list of coefficients
(or, in the case of \code{selectTrans()}, estimated transformation
parameters) for the selected models
for each fold (\code{"coefficients"}).
If \code{reps} > \code{1}, then an object of class \code{c("cvSelectList", "cvList")} is returned,
which is literally a list of \code{c("cvSelect", "cv")} objects.
}
\description{
A generic function to cross-validate a model-selection procedure,
along with a procedure that applies the \code{\link[MASS]{stepAIC}()}
model-selection function in the \pkg{MASS} package, and a procedure
for selecting predictor and response transformations in regression, which
uses the \code{\link[car]{powerTransform}()} function in the
\pkg{car} package.
}
\details{
The model-selection function supplied as the \code{procedure} argument
to \code{cvSelect()} should accept the following arguments:
\describe{
\item{\code{data}}{set to the \code{data} argument to \code{cvSelect()}.}
\item{\code{indices}}{the indices of the rows of \code{data} defining the current fold; if missing,
the model-selection procedure is applied to the full \code{data}.}
\item{other arguments}{to be passed via \code{...}
from \code{cvSelect()}.}
}
\code{procedure()} should return a two-element vector with the result
of applying a cross-validation criterion to the cases in
the current fold for the model deleting that fold, and to
all of the cases again for the model deleting the current fold.

When the \code{indices} argument is missing, \code{procedure()} returns the cross-validation criterion for all of the cases based on
the model fit to all of the cases.

For examples of model-selection functions for the \code{procedure}
argument, see the code for \code{selectStepAIC()} and for
\code{selectTrans()}.

For additional information, see the "Cross-validation of regression
models" vignette (\code{vignette("cv", package="cv")})
and the "Extending the cv package" vignette
(\code{vignette("cv-extend", package="cv")}).
}
\section{Functions}{
\itemize{
\item \code{cvSelect()}: apply cross-validation to a model-selection procedure.

\item \code{selectStepAIC()}: select a model using the \code{\link[MASS]{stepAIC}()} function in the
\pkg{MASS} package.

\item \code{selectTrans()}: select transformations of the predictors and response.

\item \code{compareFolds()}: print the coefficients from the selected models
for the several folds.

}}
\examples{
data("Auto", package="ISLR2")
m.auto <- lm(mpg ~ . - name - origin, data=Auto)
cvSelect(selectStepAIC, Auto, seed=123, model=m.auto)
cvSelect(selectStepAIC, Auto, seed=123, model=m.auto,
         AIC=FALSE, k=5, reps=3) # via BIC

data("Prestige", package="carData")
m.pres <- lm(prestige ~ income + education + women,
             data=Prestige)
cvt <- cvSelect(selectTrans, data=Prestige, model=m.pres, seed=123,
                predictors=c("income", "education", "women"),
                response="prestige", family="yjPower")
cvt
compareFolds(cvt)
cv(m.pres, seed=123)
}
\seealso{
\code{\link[MASS]{stepAIC}()}, \code{\link[car]{bcPower}},
\code{\link[car]{powerTransform}()}
}
