% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.modList.R
\name{models}
\alias{models}
\alias{cv.modList}
\alias{print.cvModList}
\alias{plot.cvModList}
\title{Cross-Validate Several Models Fit to the Same Data}
\usage{
models(...)

\method{cv}{modList}(model, data, criterion = mse, k, reps = 1, seed, quietly = TRUE, ...)

\method{print}{cvModList}(x, ...)

\method{plot}{cvModList}(
  x,
  y,
  xlab = "",
  ylab,
  main,
  axis.args = list(labels = names(x), las = 3L),
  col = palette()[2L],
  lwd = 2,
  ...
)
}
\arguments{
\item{...}{for \code{cv()}, additional arguments to be passed to the \code{cv()} method
applied to each model. For \code{models()}, two or more competing models fit to the
the same data; the several models may be named. For the \code{print()}
method, arguments to be passed to the \code{print()} method for
the individual model cross-validations. For the \code{plot()},
method, arguments to be passed to the base \code{\link[base]{plot}()}
function.}

\item{model}{a list of regression model objects,
created by \code{models()}.}

\item{data}{(required) the data set to which the models were fit.}

\item{criterion}{the CV criterion (cost) function, defaults to
\code{\link{mse}}.}

\item{k}{the number of CV folds; may be omitted, in which case the value
will depend on the default for the \code{cv()} method invoked for the
individual models.}

\item{reps}{number of replications of CV for each model.}

\item{seed}{(optional) seed for R's pseudo-random-number generator,
to be used to create the same set of CV folds for all of the models;
if omitted, a seed will be randomly generated and saved.}

\item{quietly}{If \code{TRUE} (the default), simple messages (for example about the
value to which the random-number generator seed is set), but not warnings or
errors, are suppressed.}

\item{x}{an object of class \code{"cvModList"} to be printed or plotted.}

\item{y}{the name of the element in each \code{"cv"} object to be
plotted; defaults to \code{"adj CV crit"}, if it exists, or to
\code{"CV crit"}.}

\item{xlab}{label for the x-axis (defaults to blank).}

\item{ylab}{label for the y-axis (if missing, a label is constructed).}

\item{main}{main title for the graph (if missing, a label is constructed).}

\item{axis.args}{a list of arguments for the \code{\link{axis}()}
function, used to draw the horizontal axis. In addition to
the axis arguments given explicitly, \code{side=1} (the horizontal
axis) and \code{at=seq(along=x)} (i.e., 1 to the number of models)
are used and can't be modified.}

\item{col}{color for the line and points, defaults to the second
element of the color palette; see \code{\link{palette}()}.}

\item{lwd}{line width for the line (defaults to 2).}
}
\value{
\code{models()} returns a \code{"modList"} object, the
\code{cv()} method for which returns a \code{"cvModList"} object.
}
\description{
A \code{\link{cv}()} method for an object of class  \code{"modlist"},
created by the \code{models()} function. This \code{cv()} method simplifies
the process of cross-validating several models on the same set of folds.
\code{models()} performs some
"sanity" checks, warning if the models are of different classes, and
reporting an error if they are fit to apparently different data sets or
different response variables.
}
\section{Functions}{
\itemize{
\item \code{models()}: create a list of models

\item \code{cv(modList)}: \code{cv()} method for \code{"modList"} objects

\item \code{print(cvModList)}: \code{print()} method for \code{"cvModList"} objects

\item \code{plot(cvModList)}: \code{plot()} method for \code{"cvModList"} objects

}}
\examples{
data("Duncan", package="carData")
m1 <- lm(prestige ~ income + education, data=Duncan)
m2 <- lm(prestige ~ income + education + type, data=Duncan)
m3 <- lm(prestige ~ (income + education)*type, data=Duncan)
(cv.models <- cv(models(m1=m1, m2=m2, m3=m3),
                 data=Duncan, seed=7949, reps=5))
plot(cv.models)
}
