% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver.R, R/model-algae.R, R/model-deb_abj.R,
%   R/model-debtox.R, R/model-deb_daphnia.R, R/model-guts_red.R,
%   R/model-lemna_setac.R, R/model-lemna_schmitt.R, R/model-myriophyllum.R
\name{solver}
\alias{solver}
\alias{solver,ANY-method}
\alias{solver,AlgaeWeber-method}
\alias{solver,AlgaeTKTD-method}
\alias{solver,AlgaeSimple-method}
\alias{solver,DebAbj-method}
\alias{solver,DebTox-method}
\alias{solver,DebDaphnia-method}
\alias{solver,GutsRedSd-method}
\alias{solver,GutsRedIt-method}
\alias{solver,LemnaSetac-method}
\alias{solver,LemnaSchmitt-method}
\alias{solver,MyrioExp-method}
\alias{solver,MyrioLog-method}
\title{Calls ODE solver for a particular model}
\usage{
solver(scenario, times, ...)

\S4method{solver}{ANY}(scenario, times, ...)

\S4method{solver}{AlgaeWeber}(
  scenario,
  times,
  approx = c("linear", "constant"),
  f = 1,
  method = "lsoda",
  hmax = 0.1,
  ...
)

\S4method{solver}{AlgaeTKTD}(
  scenario,
  times,
  approx = c("linear", "constant"),
  f = 1,
  method = "lsoda",
  hmax = 0.1,
  ...
)

\S4method{solver}{AlgaeSimple}(
  scenario,
  times,
  approx = c("linear", "constant"),
  f = 1,
  method = "ode45",
  hmax = 0.01,
  ...
)

\S4method{solver}{DebAbj}(scenario, times, ...)

\S4method{solver}{DebTox}(
  scenario,
  times,
  approx = c("linear", "constant"),
  f = 1,
  rule = 2,
  method = "ode45",
  ...
)

\S4method{solver}{DebDaphnia}(scenario, times, ...)

\S4method{solver}{GutsRedSd}(scenario, times, ...)

\S4method{solver}{GutsRedIt}(scenario, times, ...)

\S4method{solver}{LemnaSetac}(scenario, times, ...)

\S4method{solver}{LemnaSchmitt}(scenario, times, ...)

\S4method{solver}{MyrioExp}(scenario, times, ...)

\S4method{solver}{MyrioLog}(scenario, times, ...)
}
\arguments{
\item{scenario}{\link{scenario} object}

\item{times}{numeric vector of output times, overrides any scenario setting}

\item{...}{additional parameters passed on to \code{\link[deSolve:ode]{deSolve::ode()}}}

\item{approx}{string, interpolation method of exposure series, see \link[deSolve:forcings]{deSolve::forcings}}

\item{f}{if \code{approx="constant"}, a number between 0 and 1 inclusive, see \link[deSolve:forcings]{deSolve::forcings}}

\item{method}{string, numerical solver used by \code{\link[deSolve:ode]{deSolve::ode()}}}

\item{hmax}{numeric, maximum step length in time, see \code{\link[deSolve:ode]{deSolve::ode()}}}

\item{rule}{if \code{approx="constant"}, a number between 0 and 1 inclusive, see \link[deSolve:forcings]{deSolve::forcings}}
}
\value{
\code{data.frame} with simulation results
}
\description{
Please refer to the \emph{Modeling Howto} vignette on how to implement custom
models by overloading the \code{solver} function.
}
\details{
Please note that not all solvers support setting the parameters listed here.
In addition, some solvers may set reasonable default values for e.g. maximum step
length in time, but not all do. Please check the model documentation for
details.
}
\section{Methods (by class)}{
\itemize{
\item \code{solver(ANY)}: Default solver, raises an error

\item \code{solver(AlgaeWeber)}: numerically integrates Algae_Weber models

\item \code{solver(AlgaeTKTD)}: numerically integrates Algae_TKTD models

\item \code{solver(AlgaeSimple)}: numerically integrates Algae_Simple models

\item \code{solver(DebAbj)}: Numerically integrates DEB_abj models

\item \code{solver(DebTox)}: Numerically integrates \emph{DEBtox} scenarios

\item \code{solver(DebDaphnia)}: (deprecated) Numerically integrates \emph{DEBtox_Daphnia} scenarios

\item \code{solver(GutsRedSd)}: Numerically integrates GUTS-RED-SD models

\item \code{solver(GutsRedIt)}: Numerically integrates GUTS-RED-IT models

\item \code{solver(LemnaSetac)}: Numerically integrates Lemna_SETAC models

\item \code{solver(LemnaSchmitt)}: Numerically integrates Lemna_Schmitt models

\item \code{solver(MyrioExp)}: Numerically integrates \code{MyrioExp} models

\item \code{solver(MyrioLog)}: Numerically integrates \code{MyrioLog} models

}}
