% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleQuantiles.R
\name{SampleQuantiles}
\alias{SampleQuantiles}
\title{R6 Sample Quantiles}
\arguments{
\item{x}{An \code{R} object. Currently there are methods for numeric vectors}

\item{na.rm}{a logical value indicating whether \code{NA} values should be
stripped before the computation proceeds.}

\item{digits}{integer indicating the number of decimal places to be used.}

\item{probs}{numeric vector of probabilities with values in \code{[0,1]}.}

\item{names}{logical; if TRUE, the result has a \link[base]{names} attribute
regarding the percentiles.}

\item{type}{an integer between 1 and 9 selecting one of the nine quantile
algorithms explained in \link[stats]{quantile} to be used.}
}
\description{
The R6 class \code{SampleQuantiles} produces the sample
  quantiles corresponding to the given probabilities. It uses
  \link[stats]{quantile} from the package \pkg{stats}.
}
\examples{
x <- c(
   0.2, 0.5, 1.1, 1.4, 1.8, 2.3, 2.5, 2.7, 3.5, 4.4,
   4.6, 5.4, 5.4, 5.7, 5.8, 5.9, 6.0, 6.6, 7.1, 7.9
)
SampleQuantiles$new(x)$qx()
percentile_95 <-  SampleQuantiles$new(x, na.rm = TRUE, digits = 2, probs = 0.95)
percentile_95$qx()
percentile_75 <-  SampleQuantiles$new(x, na.rm = TRUE, digits = 3, probs = 0.75)
percentile_75$qx()
R6::is.R6(percentile_95)
}
