% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_metric_timeseries}
\alias{cvd_indicator_metric_timeseries}
\title{Retrieve time series data for a specific metric and area}
\usage{
cvd_indicator_metric_timeseries(metric_id, area_id)
}
\arguments{
\item{metric_id}{Integer (required). The ID of the metric to retrieve. Use \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}} or \code{\link[=cvd_indicator_data]{cvd_indicator_data()}} to find valid IDs.}

\item{area_id}{Integer (required). The ID of the NHS area to retrieve data for. Use \code{\link[=cvd_area_list]{cvd_area_list()}} or \code{\link[=cvd_area_search]{cvd_area_search()}} to find valid IDs.}
}
\value{
A tibble where each row represents a time period for a specific NHS area, including the observed metric value and associated target threshold. Columns include:
\describe{
\item{AreaCode}{Character. Code for the NHS area (e.g., "U60510" for a PCN, "E92000001" for England).}
\item{AreaID}{Integer. Unique identifier for the NHS area.}
\item{AreaName}{Character. Name of the NHS area (e.g., "Salford South East PCN").}
\item{Count}{Integer. Number of records included in the calculation (e.g., eligible patients).}
\item{Denominator}{Numeric. Denominator used in the metric calculation.}
\item{Factor}{Numeric. Scaling factor applied to the metric, if applicable. Often blank.}
\item{Numerator}{Numeric. Numerator used in the metric calculation.}
\item{TimePeriodID}{Integer. Identifier for the reporting period.}
\item{TimePeriodName}{Character. Display label for the time period (e.g., "To June 2024").}
\item{Value}{Numeric. Final calculated value for the metric in the given period.}
\item{TargetLabel}{Character. Descriptive label for the target threshold (e.g., "Upper threshold for QOF").}
\item{TargetValue}{Numeric. Target value to be achieved (e.g., 95).}
}
If no data is available for the given parameters, a tibble describing the error is returned.
}
\description{
Returns a tibble containing time series data for a specified metric and NHS area. The output includes both national-level (England) and local-level values across reporting periods, enabling direct comparison and trend analysis.
}
\details{
This function is designed to support longitudinal analysis of indicator performance.
It returns:
\itemize{
\item Time series values for the selected metric in the specified area
\item Corresponding national values (AreaID = 1)
\item Target thresholds (if defined) for benchmarking
}

The result includes one row per time period per area, allowing users to:
\itemize{
\item Visualise trends over time
\item Compare local performance against national averages
\item Track progress toward clinical targets
}

To find valid \code{metric_id} values, use \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}} or \code{\link[=cvd_indicator_data]{cvd_indicator_data()}}.
For valid \code{area_id} values, use \code{\link[=cvd_area_list]{cvd_area_list()}} or \code{\link[=cvd_area_search]{cvd_area_search()}}.
}
\note{
This function may take longer than 5 seconds to complete due to API response time.
}
\section{API Documentation}{

See the \href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator\%2FtimeSeriesByMetric\%2F\%3Cmetric_ID\%3E}{CVDPREVENT API documentation: Indicator time series metrics}
}

\examples{
\donttest{
# List data for Salford South East PCN (area ID 705) for 'AF: treatment with
# anticoagulants' for women people aged 60-79 years (metric ID 130):
cvd_indicator_metric_timeseries(metric_id = 130, area_id = 705) |>
  dplyr::select(AreaName, TimePeriodName, TimePeriodID, Value) |>
  tidyr::pivot_wider(
    names_from = AreaName,
    values_from = Value
  )
}

}
\seealso{
\code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}} to browse available metrics,
\code{\link[=cvd_area_list]{cvd_area_list()}} and \code{\link[=cvd_area_search]{cvd_area_search()}} to find valid area IDs,
\code{\link[=cvd_indicator_data]{cvd_indicator_data()}} to retrieve current metric values,
\code{\link[=cvd_indicator_priority_groups]{cvd_indicator_priority_groups()}} for grouped indicator metadata,
\code{\link[=cvd_indicator_metric_area_breakdown]{cvd_indicator_metric_area_breakdown()}} for area-level comparisons,
\code{\link[=cvd_indicator_person_timeseries]{cvd_indicator_person_timeseries()}} for person-level time series data
}
