% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{mslr_test2}
\alias{mslr_test2}
\title{# Modified signed-likelihood ratio test (SLRT) for equality of CVs, using summary statistics when raw measurement data are not available.}
\usage{
mslr_test2(nr, n, x, s)
}
\arguments{
\item{nr}{numeric vector lenght one, number of simulation runs}

\item{n}{a numeric vector, the number of observations in each group}

\item{x}{a numeric vector, the mean of each group}

\item{s}{a numeric vector, the standard deviation of each group}
}
\value{
a list with the test statistic and p-value
}
\description{
# Modified signed-likelihood ratio test (SLRT) for equality of CVs, using summary statistics when raw measurement data are not available.
}
\examples{

# Summary stats from Feltz and Miller 1996

miller <- data.frame(test = c('ELISA', 'WEHI', '`Viral inhibition`'),
                    Mean = c(6.8, 8.5, 6.0),
                    CV =   c(0.090, 0.462, 0.340),
                    N =    c(5, 5, 5))
# compute SD from mean and cv
miller$SD <- with(miller, CV * Mean)

 mslr_test2(nr = 1e3, n = miller$N, s = miller$SD, x = miller$Mean)


}
\references{
\url{http://link.springer.com/article/10.1007/s00180-013-0445-2}
}
