% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxnet.deviance.R
\name{fid}
\alias{fid}
\title{Helper function for Cox deviance and gradient}
\usage{
fid(x, index)
}
\arguments{
\item{x}{Sorted vector of death times.}

\item{index}{Vector of indices for the death times.}
}
\value{
A list with two arguments.
\item{index_first}{A vector of indices for the first observation at each
death time as they appear in the sorted list.}
\item{index_ties}{If there are no ties at all, this is NULL. If not, this is
a list with length equal to the number of unique times with ties. For each
time with ties, index_ties gives the indices of the observations with a
death at that time.}
}
\description{
Helps to find ties in death times of data.
}
\examples{
\dontrun{
# Example with no ties
fid(c(1, 4, 5, 6), 1:5)

# Example with ties
fid(c(1, 1, 1, 2, 3, 3, 4, 4, 4), 1:9)
}

}
\keyword{internal}
