% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.R
\name{encode}
\alias{encode}
\alias{encode,data.frame-method}
\title{Encode CWB Corpus.}
\usage{
encode(x, ...)

\S4method{encode}{data.frame}(
  x,
  corpus,
  s_attributes = NULL,
  encoding = "utf8",
  registry_dir = fs::path(tempdir(), "cwb_registry"),
  data_dir = fs::path(tempdir(), "cwb_data_dir", tolower(corpus)),
  properties = c(),
  method = c("R", "CWB"),
  verbose = TRUE,
  compress = FALSE,
  reload = TRUE,
  quietly = TRUE
)
}
\arguments{
\item{x}{A \code{data.frame} or an object inheriting from \code{data.frame} (such as
\code{tibble}, \code{data.table}).}

\item{...}{Further arguments (unused).}

\item{corpus}{ID of the CWB corpus to create.}

\item{s_attributes}{A \code{list} of \code{data.frame} objects with columns 'cpos_left'
and 'cpos_right' and columns with s-attributes, the names of which will
serve as names of s-attributes. It \code{s_attributes} is a \code{data.frame}, it will
be coerced to a \code{list}.}

\item{encoding}{Encoding as defined in the charset corpus property of the
registry file for the corpus ('latin1' to 'latin9', and 'utf8').}

\item{registry_dir}{Registry directory.}

\item{data_dir}{The data directory for the binary files of the corpus.}

\item{properties}{A named \code{character} vector with corpus properties that will
be added to the registry file describing the corpus. Names of the vector
indicate a property (such as "version") and the values of the vector the
values of a corpus property.}

\item{method}{Either 'CWB' or 'R', defaults to 'R'. See section 'Details'.}

\item{verbose}{A \code{logical} value, whether to output progress messages.}

\item{compress}{A \code{logical} value, whether to run \code{RcppCWB::cwb_huffcode()}
and \code{RcppCWB::cwb_compress_rdx()} (method 'R'), or command line tools
\code{cwb-huffcode} and \code{cwb-compress-rdx} (method 'CWB'). Defaults to \code{FALSE}
as compression is not stable on Windows.}

\item{reload}{A logical value, whether to reload the corpus to make it
immediatedly available.}

\item{quietly}{A \code{logical} value passed into \code{RcppCWB::cwb_makeall()},
\code{RcppCWB::cwb_huffcode()} and \code{RcppCWB::cwb_compress_rdx} to control
verbosity of these functions.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
# This is an example we run conditionally as packages are suggested.

dplyr_available <- requireNamespace("dplyr")
tidytext_available <- requireNamespace("tidytext")
quanteda_available <- requireNamespace("quanteda")

if (dplyr_available && tidytext_available && quanteda_available){

library(dplyr) # pipe would not be available otherwise
library(tidytext)

registry_tmp <- fs::path(tempdir(), "cwb_registry")
dir.create(registry_tmp)

tidydata <- quanteda::data_char_ukimmig2010 \%>\%
   as.data.frame() \%>\%
   as_tibble(rownames = "party") \%>\%
   rename(`text` = ".")
   
tokenstream <- tidydata \%>\%
   unnest_tokens(word, text, to_lower = FALSE, strip_punct = FALSE) \%>\%
   mutate(cpos = 0L:(nrow(.) - 1L))
   
metadata <- tokenstream \%>\% 
  group_by(party) \%>\% 
  summarise(cpos_left = min(cpos), cpos_right = max(cpos))

tokenstream \%>\%
  select(-cpos, -party) \%>\%
  encode(
    corpus = "UKIMMIG2010",
    s_attributes = metadata,
    properties = c(lang = "en")
  )
  
}
}
