% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxhull.R
\name{TrianglesXYZ}
\alias{TrianglesXYZ}
\title{Triangles of a triangulated 3D convex hull}
\usage{
TrianglesXYZ(hull)
}
\arguments{
\item{hull}{an output of \code{\link{cxhull}} applied to 3D points and 
with the option \code{triangulate=TRUE}}
}
\value{
A matrix with three columns. Each row represents the coordinates of 
  a vertex of a triangle.
}
\description{
Coordinates of the vertices of the triangles of a 
 triangulated 3D convex hull.
}
\examples{
library(cxhull)
library(rgl)
dodecahedron <- t(dodecahedron3d()$vb[-4L, ])
hull <- cxhull(dodecahedron, triangulate = TRUE)
triangles <- TrianglesXYZ(hull)
triangles3d(triangles, color = "firebrick")
}
