% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{traj_plot}
\alias{traj_plot}
\title{Plot a Trajectory in Euclidean Space}
\usage{
traj_plot(traj)
}
\arguments{
\item{traj}{\link[base]{data.frame} containing the trajectory produced by e.g.
\code{\link{make_traj}()}. It must contain
 the columns \code{traj$pos_x} and \code{traj$pos_y}.}
}
\value{
A '\code{\link[ggplot2]{ggplot}}' object.
}
\description{
This function plots the locations of a trajectory. The first and last point are
marked in red.
}
\examples{
set.seed(123)

traj <- make_traj(50,
  copula = cyl_quadsec(0.1),
  marginal_circ = "vonmises",
  parameter_circ = list(0, 1),
  marginal_lin = "weibull",
  parameter_lin = list(shape=3)
)
plot1 <- traj_plot(traj)

}
\references{
\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
\seealso{
\code{\link{cop_scat_plot}()},
\code{\link{circ_plot}()}, \code{\link{cop_plot}()}, \code{\link{scat_plot}()}.
}
