% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_select.R
\name{variable_select}
\alias{variable_select}
\title{Select observation variables.}
\usage{
variable_select(population, variables, sample = NULL,
  operation = "variance_threshold", ...)
}
\arguments{
\item{population}{tbl with grouping (metadata) and observation variables.}

\item{variables}{character vector specifying observation variables.}

\item{sample}{tbl containing sample that is used by some variable selection methods. \code{sample} has same structure as \code{population}.}

\item{operation}{optional character string specifying method for variable selection. This must be one of the strings \code{"variance_threshold"}, \code{"correlation_threshold"}, \code{"drop_na_columns"}.}

\item{...}{arguments passed to selection operation.}
}
\value{
variable-selected data of the same class as \code{population}.
}
\description{
\code{variable_select} selects observation variables based on the specified variable selection method.
}
\examples{

# In this example, we use `correlation_threshold` as the operation for 
# variable selection.

suppressMessages(suppressWarnings(library(magrittr)))
population <- tibble::data_frame(
   x = rnorm(100),
   y = rnorm(100)/1000
 )
 
population \%<>\% dplyr::mutate(z = x + rnorm(100) / 10)

sample <- population \%>\% dplyr::slice(1:30)

variables <- c("x", "y", "z")

operation <- "correlation_threshold"

cor(sample)

# `x` and `z` are highly correlated; one of them will be removed

head(population)

futile.logger::flog.threshold(futile.logger::ERROR)

variable_select(population, variables, sample, operation) \%>\% head()

}
