% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/parameters.R
\name{P}
\alias{P}
\title{Parameter transformation}
\usage{
P(trafo, parameters = NULL, compile = FALSE)
}
\arguments{
\item{trafo}{Named character vector. Names correspond to the parameters being fed into
the model (the inner parameters). The elements of tafo are equations that express
the inner parameters in terms of other parameters (the outer parameters)}

\item{parameters}{Character vector. Optional. If given, the generated parameter
transformation returns values for each element in \code{parameters}. If elements of
\code{parameters} are not in \code{names(trafo)} the identity transformation is assumed.}

\item{compile}{Logical, compile the function (see \link{funC0})}
}
\value{
a function \code{p2p(p, fixed = NULL, deriv = TRUE)} representing the parameter
transformation. Here, \code{p} is a named numeric vector with the values of the outer parameters,
\code{fixed} is a named numeric vector with values of the outer parameters being considered
as fixed (no derivatives returned) and \code{deriv} is a logical determining whether the Jacobian
of the parameter transformation is returned as attribute "deriv".
}
\description{
Parameter transformation
}
\examples{
\dontrun{
logtrafo <- c(k1 = "exp(logk1)", k2 = "exp(logk2)", A = "exp(logA)", B = "exp(logB)")
P.log <- P(logtrafo)

p.outerValue <- c(logk1 = 1, logk2 = -1, logA = 0, logB = 0)
(P.log)(p.outerValue)
}
}
\seealso{
\link{Pi} for implicit parameter transformations and
\link{concatenation} for the concatenation of parameter transformations
}

