% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R, R/eqnClass.R
\name{eqnlist}
\alias{as.eqnlist}
\alias{as.eqnlist.data.frame}
\alias{eqnlist}
\alias{is.eqnlist}
\title{Generate eqnlist object}
\usage{
eqnlist(smatrix = NULL, states = colnames(smatrix), rates = NULL,
  volumes = NULL, description = NULL)

as.eqnlist(data, volumes)

\method{as.eqnlist}{data.frame}(data, volumes = NULL)

is.eqnlist(x)
}
\arguments{
\item{smatrix}{Matrix of class numeric. The stoichiometric matrix,
one row per reaction/process and one column per state.}

\item{states}{Character vector. Names of the states.}

\item{rates}{Character vector. The rate expressions.}

\item{volumes}{Named character, volume parameters for states. Names must be a subset of the states.
Values can be either characters, e.g. "V1", or numeric values for the volume. If \code{volumes} is not
\code{NULL}, missing entries are treated as 1.}

\item{description}{Character vector. Description of the single processes.}

\item{data}{data.frame with columns Description, Rate, and one colum for each state
reflecting the stoichiometric matrix}

\item{x}{object of class \code{eqnlist}}

\item{...}{additional arguments to be passed to or from methods.}
}
\value{
An object of class \code{eqnlist}, basically a list.

Object of class \link{eqnlist}
}
\description{
The eqnlist object stores an ODE as a list of stoichiometric matrix,
rate expressions, state names and compartment volumes.

Translates a reaction network, e.g. defined by a data.frame, into an equation list object.
}
\details{
If \code{data} is a \code{data.frame}, it must contain columns "Description" (character), 
"Rate" (character), and one column per ODE state with the state names. 
The state columns correspond to the stoichiometric matrix.
}
\examples{
# Generate eqnlist from the constructor
S <- matrix(c(-1, 1, 1, -1), 
            nrow = 2, ncol = 2, 
            dimnames = list(NULL, c("A", "B")))

rates <- c("k1*A", "k2*B")
description <- c("forward", "backward")

f <- eqnlist(smatrix = S, rates = rates, description = description)
print(f)

# Convert to data.frame
fdata <- as.data.frame(f)
print(fdata)

# Generate eqnlist from data.frame and add volume parameter
f <- as.eqnlist(fdata, volumes = c(A = "Vcyt", B = "Vnuc"))
print(f)
print(as.eqnvec(f))
print(as.eqnvec(f, type = "amount"))

}

