% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqnClass.R
\name{funC0}
\alias{funC0}
\title{Evaluation of algebraic expressions defined by characters}
\usage{
funC0(
  x,
  variables = getSymbols(x, exclude = parameters),
  parameters = NULL,
  compile = FALSE,
  modelname = NULL,
  verbose = FALSE,
  convenient = TRUE,
  warnings = TRUE
)
}
\arguments{
\item{x}{Object of class \code{eqnvec} or a
named character vector with the algebraic expressions}

\item{variables}{character vector, the symbols that should be treated as variables}

\item{parameters}{character vector, the symbols that should be treated as parameters}

\item{compile}{Logical. Directly compile the file. If \code{FALSE} and modelname is available,
the C file is written but not compiled. In this case, \link{compile} has to be called separately
to compile one or more .c-files into one .so-file. 
If modelname is not available, an R function is generated and returned.}

\item{modelname}{file name of the generated C file. See description of parameter \code{compile}.}

\item{verbose}{Print compiler output to R command line.}

\item{convenient}{logical, if TRUE return a function with argument \code{...} to pass
all variables/parameters as named arguments}

\item{warnings}{logical. Suppress warnings about missing variables/parameters that are
automatically replaced by zero values.}
}
\value{
Either a prediction function \code{f(..., attach.input = FALSE)} where the 
variables/parameters are passed as named arguments or a prediction function 
\code{f(M, p, attach.input = FALSE)} where \code{M} is the matrix of variable values 
(colums with colnames correspond to different variables) and \code{p} is the vector of
parameter values.
The argument \code{attach.input} determines whether \code{M} is attached to the output.
The function \code{f} returns a matrix.
}
\description{
Evaluation of algebraic expressions defined by characters
}
\examples{
library(ggplot2)
myfun <- funC0(c(y = "a*x^4 + b*x^2 + c"))
out <- myfun(a = -1, b = 2, c = 3, x = seq(-2, 2, .1), attach.input = TRUE)
qplot(x = x, y = y, data = as.data.frame(out), geom = "line")
}
