% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dabest_effsize}
\alias{plot.dabest_effsize}
\title{Create an Estimation Plot}
\usage{
\method{plot}{dabest_effsize}(
  x,
  ...,
  color.column = NULL,
  palette = "Set1",
  float.contrast = TRUE,
  slopegraph = TRUE,
  group.summaries = "mean_sd",
  rawplot.type = c("swarmplot", "sinaplot"),
  rawplot.ylim = NULL,
  rawplot.ylabel = NULL,
  rawplot.markersize = 2,
  rawplot.groupwidth = 0.3,
  effsize.ylim = NULL,
  effsize.ylabel = NULL,
  effsize.markersize = 4,
  theme = ggplot2::theme_classic(),
  tick.fontsize = 11,
  axes.title.fontsize = 14,
  show.legend = TRUE,
  swarmplot.params = NULL,
  sinaplot.params = NULL,
  slopegraph.params = NULL
)
}
\arguments{
\item{x}{A \code{dabest_effsize} object, generated by one of the
\link[=mean_diff]{effect size} functions currently available in
\code{dabestr}.}

\item{...}{Signature for S3 generic function.}

\item{color.column}{default \code{NULL}. This is a column in the data.frame
passed to the \code{dabest} function. This column will be treated as a
\link{factor} and used to color the datapoints in the rawdata swarmplot.}

\item{palette}{default "Set1". Accepts any one of the RColorBrewer palettes,
or a vector of colors. Colors can be specified as RGB hexcode or as a named
color. See the "Palettes" section in \link{scale_color_brewer} for more on
palettes. To obtain all 657 named colors in R, enter \code{colors()} at the
console.}

\item{float.contrast}{default \code{TRUE}.  If \code{idx} in the
\code{dabest} object contains only 2 groups, \code{float.contrast = TRUE}
will plot the effect size and the bootstrap confidence interval in a
horizontally-aligned axes (also known as a
\href{https://bit.ly/2NhqUAb}{Gardner-Altman plot}).}

\item{slopegraph}{boolean, default \code{TRUE}. If the \code{dabest} object
contains paired comparisons, \code{slopegraph = TRUE} will plot the rawdata
as a \href{http://charliepark.org/slopegraphs/}{Tufte slopegraph}.}

\item{group.summaries}{"mean_sd", "median_quartiles", or \code{NULL}. Plots
the summary statistics for each group. If 'mean_sd', then the mean and
standard deviation of each group is plotted as a gapped line beside each
group. If 'median_quartiles', then the median and 25th & 75th percentiles
of each group is plotted for each group as a gapped line. If
\code{group.summaries = NULL}, the summaries are not shown.}

\item{rawplot.type}{default "beeswarm". Accepts either "beeswarm" or
"sinaplot". See \link{geom_quasirandom} and \link{geom_sina} for more
information.}

\item{rawplot.ylim}{default \code{NULL}. Enter a custom y-limit for the
rawdata plot. Accepts a vector of length 2 (e.g. c(-50, 50)) that will be
passed along to \link{coord_cartesian}.}

\item{rawplot.ylabel}{default \code{NULL}. Accepts a string that is used to
label the rawdata y-axis. If \code{NULL}, the column name passed to
\code{y} is used.}

\item{rawplot.markersize}{default 2. This is the size (in points) of the dots
used to plot the individual datapoints. There are 72 points in one inch.
See \href{https://en.wikipedia.org/wiki/Point_(typography)}{this article}
for more info.}

\item{rawplot.groupwidth}{default 0.3. This is the maximum amount of spread
(in the x-direction) allowed, for each group.}

\item{effsize.ylim}{default \code{NULL}. Enter a custom y-limit for the
effect size plot. This parameter is ignored if \code{float.contrast =
TRUE}. Accepts a vector of length 2 (e.g. \code{c(-50, 50)}) that will be
passed along to \link{coord_cartesian}.}

\item{effsize.ylabel}{default \code{NULL}. Accepts a string that is used to
label the effect size y-axis. If \code{NULL}, this axes will be labeled
"(un)paired <effect size>", where \emph{effect size} is the
\link[=mean_diff]{effect size} function used to generate the
\code{dabest_effsize} object currently being plotted.}

\item{effsize.markersize}{default 4. This is the size (in points) of the dots
used to indicate the effect size.}

\item{theme}{default \link{theme_classic}. This is the \code{ggplot2} theme
that is used to style various elements of the estimation plot.}

\item{tick.fontsize}{default 11. This controls the font size (in points) of
all tick labels.}

\item{axes.title.fontsize}{default 14. This determines the font size (in
points) of the axes titles.}

\item{show.legend}{boolean, default \code{TRUE}. If \code{FALSE}, the color
legend will not be displayed, even if \code{color.column} is supplied.}

\item{swarmplot.params}{default \code{NULL}. Supply list of \code{keyword =
value} pairs to \link{geom_quasirandom}.}

\item{sinaplot.params}{default \code{NULL}. Supply list of \code{keyword =
value} pairs to \code{\link[ggforce:geom_sina]{ggforce::geom_sina()}}.}

\item{slopegraph.params}{default \code{NULL}. Supply list of \code{keyword =
value} pairs to \code{ggplot2}'s
\code{\link[ggplot2:geom_path]{geom_line()}}.
This controls the appearance of the lines plotted for a paired slopegraph.}
}
\value{
A \code{\link[ggplot2]{ggproto}} object. This object is actually
  composed of two \code{ggplot2} objects (one for the rawdata swarmplot or
  slopegraph, another for the effect sizes and bootstrapped confidence
  intervals). These are arranged in the desired configuration (whether as a
  Gardner-Altman plot or a Cumming plot) by the
  \code{\link[cowplot]{plot_grid}()} function in the \code{cowplot} package.
}
\description{
An estimation plot has two key features. \enumerate{ \item{It presents all
datapoints as a
\href{https://github.com/eclarke/ggbeeswarm#introduction}{swarmplot} or
\href{https://CRAN.R-project.org/package=sinaplot}{sinaplot}, which orders
each point to display the underlying distribution.} \item{It presents the
effect size as a bootstrap 95 percent confidence interval on a separate but
aligned axes.} } Estimation plots emerge from estimation statistics, an
intuitive framework that avoids the pitfalls of significance testing. It uses
familiar statistical concepts: means, mean differences, and error bars. More
importantly, it focuses on the effect size of one's experiment/intervention,
as opposed to a false dichotomy engendered by \emph{P} values. This function
takes the output of the \link[=mean_diff]{effect size} functions and produces
an estimation plot.
}
\section{References}{
 \href{https://rdcu.be/bHhJ4}{Moving beyond P values:
  Data analysis with estimation graphics.} Nature Methods 2019, 1548-7105.
  Joses Ho, Tayfun Tumkaya, Sameer Aryal, Hyungwon Choi, Adam Claridge-Chang
}

\examples{
# Performing unpaired (two independent groups) analysis.
# We want to obtain the mean difference between the petal widths
# of setosa and versicolor species.
unpaired_mean_diff <- dabest(iris, Species, Petal.Width,
                             idx = c("setosa", "versicolor"),
                             paired = FALSE) \%>\%
                       mean_diff()

# Create a Gardner-Altman estimation plot.
plot(unpaired_mean_diff)


\dontrun{
# Comparing versicolor and virginica petal widths to setosa petal width.
shared_control_data <- dabeıst(iris, Species, Petal.Width,
                              idx = c("setosa", "versicolor", "virginica")) \%>\%
                       mean_diff()

# Create a Cumming estimation plot.
plot(shared_control_data)
}

}
\seealso{
\itemize{

  \item \link[=dabest]{Loading data} for effect size computation.

  \item \link[=mean_diff]{Effect size computation} from the loaded data.

  }

  Run \code{vignette("Using dabestr", package = "dabestr")} in the console to
  read more about using parameters to control the plot features.
}
