% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_output.R
\name{build_token_df}
\alias{build_token_df}
\title{Build token dataframe}
\usage{
build_token_df(json)
}
\arguments{
\item{json}{filepath of a JSON file obtained using \code{dai_async()}}
}
\value{
a token data frame
}
\description{
Builds a token dataframe from the text OCRed by
Document AI (DAI) in an asynchronous request. Rows are tokens, in the
order DAI proposes to read them. Columns are location variables
such as page coordinates and block bounding box numbers.
}
\details{
The location variables are: start index, end index,
left boundary, right boundary, top boundary, bottom boundary,
page number, and block number. Start and end indices refer to
character position in the string containing the full text.
}
\examples{
\dontrun{
token_df <- build_token_df("pdf_output.json")
}
}
