% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cla_svm.R
\name{cla_svm}
\alias{cla_svm}
\title{SVM for classification}
\usage{
cla_svm(attribute, slevels, epsilon = 0.1, cost = 10, kernel = "radial")
}
\arguments{
\item{attribute}{attribute target to model building}

\item{slevels}{possible values for the target classification}

\item{epsilon}{parameter that controls the width of the margin around the separating hyperplane}

\item{cost}{parameter that controls the trade-off between having a wide margin and correctly classifying training data points}

\item{kernel}{the type of kernel function to be used in the SVM algorithm (linear, radial, polynomial, sigmoid)}
}
\value{
A SVM classification object
}
\description{
Creates a classification object that
uses the Support Vector Machine (SVM) method for classification
It wraps the e1071 library.
}
\examples{
data(iris)
slevels <- levels(iris$Species)
model <- cla_svm("Species", slevels, epsilon=0.0,cost=20.000)

# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, iris)
train <- sr$train
test <- sr$test

model <- fit(model, train)

prediction <- predict(model, test)
predictand <- adjust_class_label(test[,"Species"])
test_eval <- evaluate(model, predictand, prediction)
test_eval$metrics
}
